//--------------------------------------------------------------
//  「MEMS マイクの入力に対して音響効果を与える」で使う GUI 等の初期化
//
//  2017/04/08, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef EFFECTOR_INIT_GUI_HPP
#define EFFECTOR_INIT_GUI_HPP

#include "F746_GUI.hpp"
#include "WaveformDisplay.hpp"
using namespace Mikami;

void InitializeGUI(
        ButtonGroup *(&onOff), ButtonGroup *(&menu),
        SeekBar *(&barReverb), SeekBar *(&barFqCh),
        NumericLabel<int> *(&frqLabel),
        WaveformDisplay *(&dispIn),
        WaveformDisplay *(&dispOut))
{
    Label myLabel(240, 8, "Reverberator and voice changer",
                  Label::CENTER, Font16);

    // ButtonGroup 用の定数
    const uint16_t BG_LEFT = 360;
    const uint16_t BG_WIDTH = 110;
    const uint16_t BG_HEIGHT = 45;

    // ButtonGroup: "ON", "OFF"
    const string ON_OFF[2] = {"ON", "OFF"};
    onOff = new ButtonGroup(BG_LEFT, 40, BG_WIDTH/2, BG_HEIGHT,
                            2, ON_OFF, 0, 0, 2, 1);

    // ButtonGroup: "THROUGH", "ECHO", "F_SHIFTER"
    const string MENU[3] = {"THROUGH", "REVERB", "VOICE CHANGER"};
    menu = new ButtonGroup(BG_LEFT, 110, BG_WIDTH, BG_HEIGHT,
                           3, MENU, 0, 10, 1, 0);

    // SeekBar 用の定数
    const uint16_t SB_LEFT = BG_LEFT - 300;
    const uint16_t SB_WIDTH = 256;
    const uint16_t Y0_E = 195;
    const uint16_t Y0_F = Y0_E + BG_HEIGHT + 5;

    // リバーブ用
    barReverb = new SeekBar(SB_LEFT, Y0_E, SB_WIDTH,
                          0, 6000, 0, "short", "", "long");
    barReverb->Inactivate();

    // 周波数シフタ用
    barFqCh = new SeekBar(SB_LEFT, Y0_F, SB_WIDTH,
                          0, 200, 100, "0", "", "200");
    barFqCh->Inactivate();
    frqLabel =  new NumericLabel<int>(
                    SB_LEFT+SB_WIDTH/2, Y0_F-28, "+%d Hz",
                    barFqCh->GetIntValue(), Label::CENTER);
    frqLabel->Redraw(GuiBase::ENUM_INACTIVE_TEXT);

    // 波形表示用
    Label inLabel(SB_LEFT-40, 55, "IN");
    dispIn = new WaveformDisplay(
                 GuiBase::GetLcd(), SB_LEFT, 60, 256, 9);
    Label outLabel(SB_LEFT-40, 125, "OUT");
    dispOut = new WaveformDisplay(
                  GuiBase::GetLcd(), SB_LEFT, 130, 256, 9);
}
#endif  // EFFECTOR_INIT_GUI_HPP
