//--------------------------------------------------------------
//  可変フィルタ用のクラス（ヘッダ）
//  （SD_PlayerSkeleton の派生クラス）
//
//  2017/03/24, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef F746_SD_VARIABLE_IIR_FILTER_HPP
#define F746_SD_VARIABLE_IIR_FILTER_HPP

#include "SD_PlayerSkeleton.hpp"
#include "BtwthDesignerDrawer.hpp"
#include "SeekbarGroup.hpp"

namespace Mikami
{
    class VariableIirFilter : public SD_PlayerSkeleton
    {
    public:
        VariableIirFilter(string str, BtwthDesignerDrawer &obj);
        virtual ~VariableIirFilter() {}

    private:
        ButtonGroup lpHp_;
        ButtonGroup onOff_;

        BtwthDesignerDrawer &drawerObj_;
        int ORDER2_;

        Array<Biquad::Coefs> ck_;
        float g0_;
        Array<Biquad> hn_;
        BilinearDesign::Type typeLH_;
        bool on_;

        // １ブロック分の信号処理の実行
        virtual void SignalProcessing();

        // 可変フィルタの遮断周波数変更
        virtual void Modefy();

        // 曲の再生中に表示する
        virtual void Display()
        {   drawerObj_.DrawResponse(); }

        // 可変フィルタ内部バッファのクリア
        virtual void Clear()
        {   for (int k=0; k<ORDER2_; k++) hn_[k].Clear(); }
    };
}
#endif  // F746_SD_VARIABLE_IIR_FILTER_HPP

