//--------------------------------------------------------------
//  Weaver 変調器を使う周波数シフタで使っているフィルタの係数
//--------------------------------------------------------------

#include "Biquad.hpp"

//--------------------------------------------------------------
// 帯域通過フィルタの係数
//--------------------------------------------------------------
// 帯域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　：10 次
// 標本化周波数： 16.00 kHz
// 遮断周波数１：  0.10 kHz
// 遮断周波数２：  6.90 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：40.00 dB
const int ORDER_BPF_ = 10;   // 次数
const Biquad::Coefs ckBpf_[ORDER_BPF_/2] = {
    {  5.650978E-01f,  3.238031E-01f,  0.000000E+00f, -1.0f},    // 1段目
    { -1.465572E+00f, -7.038566E-01f,  1.945920E+00f,  1.0f},    // 2段目
    { -1.773813E+00f, -9.479833E-01f,  1.890894E+00f,  1.0f},    // 3段目
    {  1.964750E+00f, -9.671182E-01f, -1.999561E+00f,  1.0f},    // 4段目
    {  1.993515E+00f, -9.950107E-01f, -1.999102E+00f,  1.0f} };  // 5段目
const float g0Bpf_ = 4.930705E-01f;    // 利得定数

//--------------------------------------------------------------
// Weaver 変調器で使う低域通過フィルタの係数
//--------------------------------------------------------------
// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　：8 次
// 標本化周波数： 16.00 kHz
// 遮断周波数　：  3.40 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：60.00 dB
const int ORDER_ = 8;   // 次数
const Biquad::Coefs ck_[ORDER_/2] = {
    { 1.119022E+00f, -4.002827E-01f,  1.652591E+00f,  1.0f},    // 1段目
    { 7.920125E-01f, -6.603073E-01f,  4.692874E-01f,  1.0f},    // 2段目
    { 5.465819E-01f, -8.629465E-01f, -6.053351E-02f,  1.0f},    // 3段目
    { 4.528130E-01f, -9.652067E-01f, -2.237304E-01f,  1.0f} };  // 4段目
const float g0Lpf_ = 1.477248E-02f;    // 利得定数
