//-----------------------------------------------------------
//  波形表示のためのクラス（ヘッダ）
//
//  2017/03/16, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef F746_WAVEFORM_DISPLAY_HPP
#define F746_WAVEFORM_DISPLAY_HPP

#include "mbed.h"
#include "F746_GUI.hpp"         // 筆者の作った GUI 用ライブラリ
#include "Array.hpp"            // 筆者の作った一次元配列用ライブラリ

namespace Mikami
{
    class WaveformDisplay
    {
    public:
        WaveformDisplay(LCD_DISCO_F746NG &lcd,
                        uint16_t x0, uint16_t y0,
                        const Array<int16_t>& xn,
                        uint32_t backColor)
            : X0_(x0), Y0_(y0), xn_(xn), N_DATA_(xn.Length()),
              BACK_COLOR_(backColor), lcd_(lcd) {}

        void Execute();     // 波形表示
        
    private:
        const uint16_t X0_, Y0_;
        const Array<int16_t>& xn_;  // 表示するデータのバッファ
        const int N_DATA_;          // 表示するデータの数
        const uint32_t BACK_COLOR_;
        static const uint16_t R_SHIFT_ = 6; // 表示の際のスケーリング･ファクタ
        static const int LIMIT_ = 65;       // 表示の振幅の最大値

        LCD_DISCO_F746NG &lcd_;     // LCD のオブジェクトの参照

        uint16_t Clip(int16_t xn);  // 縦方向のクリッピングと縦方向の位置の移動

        // コピーコンストラクタと代入演算子の使用禁止
        WaveformDisplay(const WaveformDisplay& );
        WaveformDisplay& operator=(const WaveformDisplay& );
    };
}
#endif  // F746_WAVEFORM_DISPLAY_HPP
