//-----------------------------------------------------------
//  波形表示のためのクラス
//
//  2017/03/16, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#include "WaveformDisplay.hpp"

// 波形表示
void WaveformDisplay::Execute()
{
    // 以前の波形を消去
    lcd_.SetTextColor(BACK_COLOR_);
    lcd_.FillRect(X0_, Y0_-LIMIT_, N_DATA_, LIMIT_*2+1);

    // 横軸の描画
    lcd_.SetTextColor(LCD_COLOR_CYAN);
    lcd_.DrawLine(X0_-5, Y0_, X0_+N_DATA_+5, Y0_);

    // 波形の描画
    lcd_.SetTextColor(LCD_COLOR_WHITE);
    uint16_t x1 = X0_;
    uint16_t y1 = Clip(xn_[0]);
    for (int n=1; n<N_DATA_; n++)
    {
        uint16_t x2 = X0_ + n;
        uint16_t y2 = Clip(xn_[n]);
        lcd_.DrawLine(x1, y1, x2, y2);
        x1 = x2;
        y1 = y2;
    }
}
    
// 縦方向のクリッピングと縦方向の位置の移動
uint16_t WaveformDisplay::Clip(int16_t xn)
{
    int16_t x = xn >> R_SHIFT_; // スケーリング
    if (x >  LIMIT_ ) x =  LIMIT_;
    if (x < -LIMIT_ ) x = -LIMIT_ ;
    return Y0_ - x;
}
