//--------------------------------------------------------------
//  MEMS マイクから CODEC を使って入力したサウンド信号の波形の表示
//      標本化周波数： 16 kHz
//
//  ライブラリのリビジョン：
//      F746_GUI    rev.32
//      mbed        rev.138
//
//  2017/04/09, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#include "SAI_InOut.hpp"        // 自作 SAI 用ライブラリ
#include "F746_GUI.hpp"         // 自作 GUI 用ライブラリ
#include "WaveformDisplay.hpp"  // 波形表示用
using namespace Mikami;         // 自作ライブラリで使っている名前空間

int main()
{
    Label title(240, 12, "Simplified Oscilloscope",
                Label::CENTER, Font20);

    const uint32_t N_DATA = 420;    // 表示するデータ数
    Array<int16_t> xn(N_DATA);      // 表示で使うデータ

    // 波形表示用のオブジェクト生成
    WaveformDisplay waveDisp(GuiBase::GetLcd(), 30, 130,
                             xn, GuiBase::ENUM_BACK);

    // 入力の再開と中断のためのオブジェクトの生成
    ButtonGroup runStop(365, 235, 55, 35, 2,
                        (string[]){"RUN", "STOP"},
                        5, 0, 2, 0);

    // サウンド信号入力用 SAI オブジェクト生成，入力：MEMS マイク
    SaiIO mySai(SaiIO::INPUT, N_DATA, AUDIO_FREQUENCY_16K,
                INPUT_DEVICE_DIGITAL_MICROPHONE_2);
    mySai.RecordIn();       // 入力開始

    while (true)
    {
        int num;
        if (runStop.GetTouchedNumber(num))
        {
            if (num == 0) mySai.ResumeIn(); // 入力再開
            else          mySai.PauseIn();  // 入力中断
        }

        if (mySai.IsCaptured()) // 入力データがそろったら波形を表示する
        {
            for (int n=0; n<N_DATA; n++)
                mySai.Input(xn[n], xn[n]);  // 片方のチャンネルのみ表示
            waveDisp.Execute();     // 波形の表示
        }
    }
}
