//---------------------------------------------------------
//  SeekBar, NumericLabel, ButtonGroup のデモプログラム
//  Demo program of SeekBar, NumericLabel, and ButtonGroup
//
//      ＜インポートしたライブラリのリビジョン＞
//          F746_GUI     33
//          mbed        161
//
//  2018/03/12, Copyright (c) 2018 MIKAMI, Naoki
//---------------------------------------------------------

#include "F746_GUI.hpp"
using namespace Mikami;

int main()
{
    Label label1(240, 40, "Example", Label::CENTER, Font16);
    Label label2(240, 60, "SeekBar, NumericLabel, ButtonGroup",
                 Label::CENTER, Font16);

    SeekBar myBar(100, 200, 250, -1, 1, 0, "-1", "0", "1");
    NumericLabel<float> myLabel(210, 150, "%5.2f", 0);
    ButtonGroup bG(420, 196, 50, 36, 2, (string[]){"ON", "OFF"},
                   0, 5, 1, 0);

    while (true)
    {
        if (myBar.Slide())
        {
            float val = myBar.GetValue();
            myLabel.Draw(val);
            printf("val = %f\r\n", val);
        }

        int num;
        if (bG.GetTouchedNumber(num))
        {
            if (num == 0) myBar.Activate();
            else          myBar.Inactivate();
        }
        wait(0.05f);
    }
}
