//-----------------------------------------------------------------------
//  GuiBase とその派生クラスのデモプログラム
//  Demo program for GuiBase class and its derivertive classes
//
//      GuiBase, Button, ButtonGroup, Label, NumericLabel, BlinkLabel,
//      SeekBar, SeekbarGroup, NumericUpDown
//
//      ＜インポートしたライブラリのリビジョン＞
//          F746_GUI     33
//          mbed        161
//
//  2018/03/12, Copyright (c) 2018 MIKAMI, Naoki
//-----------------------------------------------------------------------

#include "F746_GUI.hpp"

int main()
{
    Label obj10(240, 2, "Demo: GUI parts, 2018/03/12", Label::CENTER, Font16);
    Label obj11(240, 20, "Button, ButtonGroup, Label, NumericLabel, BlinkLabel,",
                Label::CENTER);
    Label obj12(240, 32, "SeekBar, SeekbarGroup, NumericUpDown",
                Label::CENTER);

    Button button1(10, 54, 30, 35, "1");
    Button button2(42, 54, 30, 35, "2");

    const int NUMBER_BUTTONS = 4;
    const string STR1[NUMBER_BUTTONS] = {"Button1", "Button2", "Button3", "Activate"};
    ButtonGroup bGroup1(168, 54, 66, 35,  NUMBER_BUTTONS, STR1, 2, 2, 3, 1,
                        Font12, LCD_COLOR_WHITE, 0xFF003538, 0xFFB70068, 0xFFFF7FFF);
    NumericLabel<int> bTouch(240, 112, "", Label::LEFT, Font12, LCD_COLOR_MAGENTA);

    // Control status of bGroup2
    ButtonGroup bGroup2(168, 150, 66, 40,  3, (string[]){"0", "1", "2"}, 5, 5, 3);
    bGroup2.InactivateAll();
    
    // Switching buttons to control barH active or inactive
    ButtonGroup bGroup3(78, 54, 40, 35,  2, (string[]){"ON", "OFF"}, 0, 0, 2);
    bGroup3.TouchedColor(0);

    Button doNotTouch(250, 220, 120, 40, "Don't Touch", Font12,
                      GuiBase::ENUM_TEXT, GuiBase::ENUM_BACK,
                      LCD_COLOR_DARKGREEN, LCD_COLOR_RED);

    // Using default value for argument (Horizontal)
    SeekBar barH(20, 250, 200, -5, 5, 0, "-5", "", "5");
    NumericLabel<float> numLabel1(80, 205, "%5.1f", barH.GetValue());
    NumericLabel<int> numLabel2(130, 205, "%3d", (int)barH.GetValue());
    NumericLabel<int> numLabel3(160, 205, "%3d");
    
    // SeekbarGroup (vertical)
    SeekbarGroup barV(410, 130, 121, 2, 45, -6, 6, 2,
                      SeekBar::Vertical, 0xFFA0FFC0);

    Array<NumericLabel<float> *> numLabel4(2);
    for (int n=0; n<2; n++) numLabel4[n] =
        new NumericLabel<float>(410+n*45, 104, "%4.1f", barV.GetValue(n), Label::CENTER);

    NumericLabel<int> numLabel5(455, 92, "%1d", barV.GetIntValue(0), Label::CENTER);

    // Test of left-, cenrer-, and right-justified
    Label leftJustified(420, 54, "ABC", Label::LEFT);
    Label centerJustified(420, 64, "ABC", Label::CENTER);
    Label rightJustified1(420, 74, "ABC", Label::RIGHT);
    
    // NumericalUpDown
    NumericUpDown nUd(3, 10, 190, 100, 999, 10);

    while (true)
    {
        if (button1.Touched()) button2.Draw();
        if (button2.Touched()) button1.Draw();

        int num;
        if (bGroup1.GetTouchedNumber(num))
            bTouch.Draw("Button%d touched", num+1);
        if (num == 3)
            bGroup2.ActivateAll();

        if (bGroup2.GetTouchedNumber(num))
        switch (num)
        {
            case 0: button1.Activate();
                    bGroup1.Activate(1);
                    bGroup1.DrawAll();
                    break;
            case 1: button1.Inactivate();
                    bGroup1.Inactivate(1);
                    break;
            case 2: bGroup1.EraseAll();//for (int n=0; n<4; n++) bGroup1.Erase(n);
                    for (int n=0; n<2; n++)
                    {
                        barV.Draw(n, 0);    // reset seekbar
                        numLabel4[n]->Draw("%4.1f", barV.GetValue(n));
                    }
                    break;
        }

        if (barH.Slide())
        {
            numLabel1.Draw("%5.1f", barH.GetValue());
            int8_t x = (int8_t)barH.GetValue();
            numLabel2.Draw("%3d", x);

            numLabel3.Draw(barH.GetIntValue());            
        }        

        int sbNum;
        if (barV.GetSlidedNumber(sbNum))
        {
            if (sbNum == 0) numLabel4[sbNum]->Draw("%4.1f", barV.GetValue(sbNum));
            else            numLabel4[sbNum]->Draw("%4.1f", barV.GetValue(sbNum));
            if (sbNum == 1) numLabel5.Draw("%1d", barV.GetIntValue(sbNum));
        }
        // If "doNotTouch" button touched, trapped into endless loop
        if (doNotTouch.Touched())
            BlinkLabel warning(250, 200, "You must reset", Label::LEFT, Font16);
            
        // SeekBar active inactive switching
        if (bGroup3.Touched(0))
        {
            barH.Activate();
            barV.ActivateAll();
        }
        if (bGroup3.Touched(1))
        {
            barH.Inactivate();
            barV.InactivateAll();
        }
        
        if (nUd.Touched()) {}   // Example of NumericalUpDown

        wait(0.02f);
    }
}

