//--------------------------------------------------------------
//  ヒルベルト変換用フィルタ
//
//  Copyright (c) 2018 MIKAMI, Naoki,  2018/03/19
//--------------------------------------------------------------

#ifndef HILBERT_TRANSFORM_HPP
#define HILBERT_TRANSFORM_HPP

#include "mbed.h"

namespace Mikami
{
    class Hilbert
    {
    public:
        // order: 4K+2 とすること, K: 整数
        Hilbert(int order, const float hk[])
            : ORDER_(order), HN_((order-2)/4+1, hk), xn_(order+1, 0.0f)
        {
            if ( ((order-2) % 4) != 0)
                fprintf(stderr, "order must be 4*K+2, K: integer\r\n");
        }
        
        // yI: 同相信号
        // yQ: 直角位相信号
        void Execute(float xin, float& yI, float& yQ)
        {
            yQ = 0.0;
            xn_[0] = xin;

            for (int k=0; k<=ORDER_/4; k++)
                yQ = yQ + HN_[k]*(xn_[2*k] - xn_[ORDER_-2*k]);
            yI = xn_[ORDER_/2];             // 同相信号

            for (int k=ORDER_; k>0; k--)
                xn_[k] = xn_[k-1];          // 遅延器の入力信号の移動        
        }
        
    private:
        const int ORDER_;       // 次数
        const Array<float> HN_; // 係数
        Array<float> xn_;       // 入力信号用バッファ

        // disallow copy constructor and assignment operator
        Hilbert(const Hilbert&);
        Hilbert& operator=(const Hilbert&);
    };
}
#endif  // HILBERT_TRANSFORM_HPP


