//--------------------------------------------------------------
//  Hilbert 変換フィルタを利用する MEMS マイクの入力に対して周波数シフタ
//  で使う GUI 等の初期化
//
//  2018/03/18, Copyright (c) 2018 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef EFFECTOR_INIT_GUI_HPP
#define EFFECTOR_INIT_GUI_HPP

#include "F746_GUI.hpp"
#include "WaveformDisplay.hpp"
using namespace Mikami;

void InitializeGUI(
        ButtonGroup *(&onOff), ButtonGroup *(&menu),
        SeekBar *(&barFqCh), NumericLabel<int> *(&frqLabel),
        WaveformDisplay *(&dispIn),
        WaveformDisplay *(&dispOut))
{
    Label myLabel(240, 8, "Frequency shifter", Label::CENTER, Font16);

    // ButtonGroup 用の定数
    const uint16_t BG_LEFT = 360;
    const uint16_t BG_WIDTH = 110;
    const uint16_t BG_HEIGHT = 45;

    // ButtonGroup: "ON", "OFF"
    onOff = new ButtonGroup(BG_LEFT, 40, BG_WIDTH/2, BG_HEIGHT,
                            2, (string[]){"ON", "OFF"}, 0, 0, 2, 1);

    // ButtonGroup: "THROUGH", "F_SHIFTER"
    menu = new ButtonGroup(BG_LEFT, 110, BG_WIDTH, BG_HEIGHT,
                           2, (string[]){"THROUGH", "VOICE CHANGER"},
                           0, 10, 1, 0);

    // SeekBar 用の定数
    const uint16_t SB_LEFT = BG_LEFT - 300;
    const uint16_t SB_WIDTH = 256;
    const uint16_t Y0_E = 195;
    const uint16_t Y0_F = Y0_E + BG_HEIGHT + 5;

    // 周波数シフタ用
    barFqCh = new SeekBar(SB_LEFT, Y0_F, SB_WIDTH,
                          0, 200, 100, "0", "", "200");
    barFqCh->Inactivate();
    frqLabel =  new NumericLabel<int>(
                    SB_LEFT+SB_WIDTH/2, Y0_F-28, "+%d Hz",
                    barFqCh->GetIntValue(), Label::CENTER);
    frqLabel->Redraw(GuiBase::ENUM_INACTIVE_TEXT);

    // 波形表示用
    Label inLabel(SB_LEFT-40, 55, "IN");
    dispIn = new WaveformDisplay(
                 GuiBase::GetLcd(), SB_LEFT, 60, 256, 9);
    Label outLabel(SB_LEFT-40, 125, "OUT");
    dispOut = new WaveformDisplay(
                  GuiBase::GetLcd(), SB_LEFT, 130, 256, 9);
}
#endif  // EFFECTOR_INIT_GUI_HPP
