//-----------------------------------------------------------
//  Frequency response for FIR filter of direct form
//
//  2016/04/17, Copyright (c) 2016 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef FIR_DIRECT_FREQUENCY_RESPONSE_HPP
#define FIR_DIRECT_FREQUENCY_RESPONSE_HPP

#include "FrequancyResponseBase.hpp"

namespace Mikami
{
    class FIR_FrqResp : public FrequencyResponse
    {
    public:
        FIR_FrqResp() : ORDER_(10)
        {
            float hk[] =
            {
                -3.391730E-02f,  1.206756E-03f,  5.917430E-02f,  1.457397E-01f,
                 2.247430E-01f,  2.567399E-01f,  2.247430E-01f,  1.457397E-01f,
                 5.917430E-02f,  1.206756E-03f, -3.391730E-02f
            };
            h_ = new float[ORDER_+1];
            for (int k=0; k<=ORDER_; k++) h_[k] = hk[k];
        }

        // 周波数応答の絶対値を返す関数, 引数: z^(-1)
        virtual float AbsH_z(Complex u)
        {
            Complex h = 0;
            for (int k=ORDER_; k>=0; k--)
                h = h*u + h_[k];
            return abs(h);       
        }
        
    private:
        const int ORDER_;
        float *h_;
    };
}
#endif  // FIR_DIRECT_FREQUENCY_RESPONSE_HPP

