//-----------------------------------------------------------
//  Frequency response for differentiator
//
//  2016/04/17, Copyright (c) 2016 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef DIFF_FREQUENCY_RESPONSE_HPP
#define DIFF_FREQUENCY_RESPONSE_HPP

#include "FrequancyResponseBase.hpp"

namespace Mikami
{
    class Diff_FrqResp : public FrequencyResponse
    {
    public:
        Diff_FrqResp() {}

        // 周波数応答の絶対値を返す関数, 引数: z^(-1)
        virtual float AbsH_z(Complex u)
        {   return abs(0.5f*(1.0f - u)); }
    };
}
#endif  // DIFF_FREQUENCY_RESPONSE_HPP
