//-----------------------------------------------------------
//  Frequency response for biquad LPF
//
//  2016/04/19, Copyright (c) 2016 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef BIQUAD_FREQUENCY_RESPONSE_HPP
#define BIQUAD_FREQUENCY_RESPONSE_HPP

#include "FrequancyResponseBase.hpp"

namespace Mikami
{
    class Biquad_FrqResp : public FrequencyResponse
    {
    public:
        Biquad_FrqResp(float a1, float a2, float b0, float b1, float b2)
            : a1_(a1), a2_(a2), b0_(b0), b1_(b1), b2_(b2) {}

        // 周波数応答の絶対値を返す関数, 引数: z^(-1)
        virtual float AbsH_z(Complex u)
        {
            Complex h = b0_ + (b1_ + b2_*u)*u ;
            h = h/(1.0f - (a1_ + a2_*u)*u);
            return abs(h);
        }

    private:
        const float a1_, a2_, b0_, b1_, b2_;
    };
}
#endif  // BIQUAD_FREQUENCY_RESPONSE_HPP

