//-----------------------------------------------------------
//  周波数特性を描画するための FrqRespDrawer クラスの使用例
//
//  2017/03/17, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------------

#include "FrquencyResponseDrawer.hpp"
#include "FIR_FrqResp.hpp"
#include "Diff_FrqResp.hpp"
#include "Biquad_FrqResp.hpp"
#include "Button.hpp"

using namespace Mikami;

int main()
{
    Label title(240, 8, "Example of FrequencyResponseDrawer class",
                Label::CENTER, Font16, LCD_COLOR_YELLOW);
    const uint16_t X0 = 60;
    const uint16_t Y0 = 230;
    const float DB1 = 3;
    const int FS = 20000;

// 周波数特性を描画する対象となるクラスのオブジェクト
//      周波数応答の絶対値このクラスの中でをこのクラスで定義すること
//      このクラスは FrequencyResponse クラスを継承する派生クラスとして定義すること
    FIR_FrqResp firFrqResp;         // 低域通過 FIR フィルタ
    Diff_FrqResp diffFrqResp;       // 差分器
    Biquad_FrqResp biquadFrqResp(   // 高域通過 IIR フィルタ
        2.647205E-01f, -2.800973E-01f,
        3.671389E-01f, -7.241241E-01f,  3.671389E-01f);
                            
// 周波数特性を描画するためのクラス
    FrqRespDrawer drawer(X0, 100.0f, 10000.0f, 150, Y0, -60, 0, DB1, 10, FS);
    
    drawer.DrawAxis();                  // 目盛線の描画

    FrqRespDrawer::AxisX_Char numX[] =  // 横軸の目盛値を描画する際に使う構造体の配列
        {{  100, "0.1"}, {  200, "0.2"}, {  500, "0.5"},
         { 1000,   "1"}, { 2000,   "2"}, { 5000,   "5"},
         {10000,  "10"}};
    drawer.DrawNumericX(numX, 7, 6, "Frequency [kHz]"); // 横軸の目盛
    drawer.DrawNumericY(-24, -6, 20, "%3d");            // 縦軸の目盛は 20 dB 間隔
    
    Button next(420, 230, 60, 40, "NEXT");

    drawer.DrawGraph(firFrqResp);                       // 低域通過 FIR フィルタの周波数特性の描画
    while (!next.Touched()) {}
    drawer.Erase(1);
    wait(0.2f);
    drawer.DrawAxis();                  // 目盛線の描画
    drawer.DrawGraph(diffFrqResp, LCD_COLOR_MAGENTA);   // 差分器の周波数特性の描画
    while (!next.Touched()) {}
    drawer.Erase();
    wait(0.2f);
    drawer.DrawAxis();                  // 目盛線の描画
    drawer.DrawGraph(biquadFrqResp, LCD_COLOR_GREEN);   // 高域通過 IIR フィルタの周波数特性の描画
    while (!next.Touched()) {}
    drawer.Erase();
    next.Erase();

    // ３種類の周波数特性を重ねて表示
    drawer.DrawAxis();                  // 目盛線の描画
    drawer.DrawGraph(firFrqResp);                       // 低域通過 FIR フィルタ
    drawer.DrawGraph(diffFrqResp, LCD_COLOR_MAGENTA);   // 差分器
    drawer.DrawGraph(biquadFrqResp, LCD_COLOR_GREEN);   // 高域通過 IIR フィルタ
    
    while (true) {}
}
