//-----------------------------------------------------------
//  Measurement execution time of "FftReal"
//      for Nucleo-401 and DISCO-F746
//
//  2016/01/17, Copyright (c) 2016 MIKAMI, Naoki
//-----------------------------------------------------------

#include "fftReal.hpp"
using namespace Mikami;


const int N_FFT_ = 128;     // number of date for FFT
//const int N_FFT_ = 256;     // number of date for FFT
//const int N_FFT_ = 512;     // number of date for FFT

DigitalOut dOut(D7);

int main()
{
    printf("SystemCoreClock = %d MHz\r\n", SystemCoreClock/1000000);
    
    FftReal fft(N_FFT_);    // Declaration of FFT object

    float xn[N_FFT_];
    Complex y[N_FFT_];
    
    srand(1234);
    for (int n=0; n<N_FFT_; n++)
        xn[n] = 2.0f*rand()/(float)RAND_MAX - 1.0f;
    
    while (true)
    {
        dOut = 1;
        fft.Execute(xn, y);
        dOut = 0;
        wait_ms(1);
    }
}
