//---------------------------------------------------------------
//  Demo program of Button class and ButtonGroup class
//
//  2016/02/22, Copyright (c) 2016 MIKAMI, Naoki
//---------------------------------------------------------------

#include "button_group.hpp"

using namespace Mikami;

TS_DISCO_F746NG ts_;
LCD_DISCO_F746NG lcd_;

int main()
{
    const int Y0 = 5;
    const int X1 = 30;
    const int Y1 = 100;

    const uint32_t BACK_COLOR = 0xFF006A6C;             // teal green
    const uint32_t INACTIVE = BACK_COLOR & 0xE0FFFFFF;  // color for inactive button
    lcd_.Clear(BACK_COLOR);
       
    const int NUMBER_BUTTONS = 4;
    const string STR[NUMBER_BUTTONS] = {"Button1", "Button2", "Button3", "Button4"};
    ButtonGroup bGroup(lcd_, ts_, 10, Y0, 66, 40,
                       LCD_COLOR_BLUE, BACK_COLOR, NUMBER_BUTTONS, STR, 5, 5, 3);
                       
    const string STR_SW[2] = {"ON", "OFF"};
    ButtonGroup sw(lcd_, ts_, 10, 160, 66, 40,
                   LCD_COLOR_GREEN, BACK_COLOR, 2, STR_SW, 5, 0, 2);
                       
    Button reset(lcd_, ts_, 410, Y0, 60, 40,
                 LCD_COLOR_BLUE, BACK_COLOR, "Reset", Font12);
    reset.Draw(INACTIVE, LCD_COLOR_GRAY);

    const string MULTI[2] = {"ON", "OFF"};
    ButtonGroup multiTouch(lcd_, ts_, 300, Y0+100, 60, 40,
                 LCD_COLOR_BLUE, BACK_COLOR, 2, MULTI, 5, 0, 2);
    multiTouch.Draw(0, LCD_COLOR_DARKBLUE);

    lcd_.SetTextColor(LCD_COLOR_WHITE);
    lcd_.SetFont(&Font16);
    lcd_.DisplayStringAt(250, Y0+80, (uint8_t *)"Multi-touch ON, OFF", LEFT_MODE);

    lcd_.SetFont(&Font20);
    lcd_.DisplayStringAt(120, 250, (uint8_t *)"02/22 22:36", LEFT_MODE);
        
    DigitalOut dOut(D7);
    int num;

    while (true)
    {
        dOut = 1;
        bool touched = bGroup.GetTouchedNumber(num, LCD_COLOR_DARKBLUE);
        dOut = 0;
        
        if (touched)
        {
            char str[20];
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_WHITE);
            sprintf(str, "Button%d pressed", num+1);
            lcd_.DisplayStringAt(X1, Y1, (uint8_t *)str, LEFT_MODE);
            
            reset.Redraw();
        }
        
        if (sw.Touched(0, LCD_COLOR_DARKGREEN))
            lcd_.DisplayStringAt(X1, 210, (uint8_t *)"ON ", LEFT_MODE);
        if (sw.Touched(1, LCD_COLOR_DARKGREEN))
            lcd_.DisplayStringAt(X1, 210, (uint8_t *)"OFF", LEFT_MODE);
        
        if (reset.Touched())
        {
            bGroup.Redraw(num);
            reset.Draw(INACTIVE, LCD_COLOR_GRAY);
            lcd_.SetFont(&Font16);
            lcd_.DisplayStringAt(X1, Y1, (uint8_t *)"               ", LEFT_MODE);
        }
        
        int mNum;
        if (multiTouch.GetTouchedNumber(mNum, LCD_COLOR_DARKBLUE))
        {
            Button::SetMultiTouch(mNum == 0);   // Set or reset multi-touch
            if (mNum == 0)
                lcd_.DisplayStringAt(320, Y0+150, (uint8_t *)"ON ", LEFT_MODE);
            else
                lcd_.DisplayStringAt(320, Y0+150, (uint8_t *)"OFF", LEFT_MODE);
        }
        wait(0.01f);
    }
}

