//-----------------------------------------------------------
//  SiaIO class for output (Header)
//  2016/04/17, Copyright (c) 2016 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef F746_SAI_IO_HPP
#define F746_SAI_IO_HPP

#include "mbed.h"
#include "stm32746g_discovery_audio.h"
#include "BSP_AudioOut_Overwrite.hpp"

namespace Mikami
{
    class SaiIO_O
    {
    public:
        SaiIO_O(int size, int fs);
        ~SaiIO_O();

        void InitCodecOut();
        
        bool IsXferred();
        void Output(int16_t xL, int16_t xR);
        
        void ResetXferred() { xferred_ = false; }
        int32_t GetLength() { return nData_; }
        void Stop()   { BSP_AUDIO_OUT_Stop(CODEC_PDWN_SW); }
        void Pause()  { BSP_AUDIO_OUT_Pause(); }
        void Resume() { BSP_AUDIO_OUT_Resume(); }

        
        // These three member functions are called from
        // callback functions in "BSP_AudioOut_Overwrite.cpp"

        // Called form BSP_AUDIO_OUT_HalfTransfer_CallBack()
        static void FillBuffer1st() { FillBuffer(0); }
        // Called form BSP_AUDIO_OUT_TransferComplete_CallBack()
        static void FillBuffer2nd() { FillBuffer(bufferSize_/2); }
        // Also called form BSP_AUDIO_OUT_Error_CallBack()
        static void ErrorTrap();

    private:
        const int FS_;
        static const uint8_t VOLUME_OUT_ = 90;

        static int32_t nData_;
        static int32_t bufferSize_;

        static int16_t* outBuffer_;
        static int16_t* tmp_;       

        static __IO bool xferred_;
        
        __IO int32_t tmpIndex_;

        static void FillBuffer(uint32_t offset);
    };
}
#endif  // F746_SAI_IO_HPP
