//------------------------------------------------------------------------------
//  IIR フィルタを双一次 z 変換で設計し，その周波数特性を描画するためのクラス -- Header
//  
//  2016/04/17, Copyright (c) 2016 MIKAMI, Naoki
//------------------------------------------------------------------------------

#ifndef F746_DISIGNER_AND_DRAWER_HPP
#define F746_DISIGNER_AND_DRAWER_HPP

#include "NumericLabel.hpp"
#include "TouchPanelDetectorX.hpp"
#include "FrquencyResponseDrawer.hpp"
#include "BilinearDesignLH.hpp"
#include "IIR_CascadeFrqResp.hpp"

namespace Mikami
{
    class DesignerDrawer
    {
    public:
        // Constructor
        DesignerDrawer(uint16_t x0, uint16_t y0,
                       uint16_t db10, int fs, int order,
                       float fc, uint16_t fL, uint16_t fH,
                       BilinearDesign::Type lpHp);

        ~DesignerDrawer();

        // フィルタの再設計と周波数特性の再描画
        bool ReDesignAndDraw(Biquad::Coefs *ck, float &g0,
                             BilinearDesign::Type lpHp);
        
        // 周波数特性の描画
        void DrawResponse();

        void GetCoefficients(Biquad::Coefs *ck, float &g0);
        
        uint16_t GetOrder() { return ORDER_; }

    private:
        LCD_DISCO_F746NG *lcd_;
        TS_DISCO_F746NG *ts_;

        const uint16_t X0_, Y0_;
        const uint16_t DB10_;
        const uint16_t ORDER_;
        const uint16_t CURSOR_Y0_, CURSOR_LENGTH_;
        const uint16_t LOWER_F_, HIGHER_F_;
        const uint32_t CURSOR_COLOR_, CURSOR_TOUCHED_COLOR_;

        IIR_CascadeFrqResp frqResp_;    // IIR フィルタの周波数応答に対応するオブジェクト
        BilinearDesign::Coefs *coefs_;  // 設計された係数
        Biquad::Coefs *ck_;
        float g0_;                      // 設計された係数(利得定数)
        
        int fC_;    // 遮断周波数

        uint16_t cursorX_, oldCursorX_;
        bool cursorRedraw_;
        BilinearDesign::Type lp_;
        
        FrqRespDrawer *drawerObj_;
        BilinearDesign *designObj_;
        TouchPanelDetectorX *tp_;
        NumericLabel<int> *lblFrq_; // 遮断周波数表示用
        
        // 周波数を 10, 20, 50, 100 Hz の倍数にする
        int Frq10(float f);
        
        // 周波数特性の目盛値の描画
        void DrawAxisNum();
    };
}
#endif  // F746_DISIGNER_AND_DRAWER_HPP
