
#ifndef FREQUENCY_RESPONSE_BASE_HPP
#define FREQUENCY_RESPONSE_BASE_HPP

#include <complex>  // requisite for complex

namespace Mikami
{
    typedef complex<float> Complex; // define "Complex"

    class FrequencyResponse
    {
    public:
        // 周波数応答の絶対値を返す関数, 引数: z^(-1)
        virtual float AbsH_z(Complex u) = 0;

    protected:
        FrequencyResponse() {}
    };
}
#endif  // F746_FREQUENCY_RESPONSE_BASE_HPP
