//--------------------------------------------------------------
//  フィルタ処理付き SD オーディオプレーヤーで使う大域関数（ヘッダ）
//
//  2016/04/07, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef F746_MY_FUNCTIONS_HPP
#define F746_MY_FUNCTIONS_HPP

#include "sai_io_o.hpp"
#include "ButtonGroup.hpp"
#include "FileSelector.hpp"
#include "DesignerDrawer.hpp"
#include "SD_BinaryReader.hpp"

using namespace Mikami;

// １フレーム分の信号処理 (IIR フィルタ) の実行
void ProcessSignal(SD_BinaryReader &sdReader, SaiIO_O &mySai,
                   int16_t sn[], float g0, Biquad hn[],
                   int order, bool filterOn);

// SD カードのファイルのオープン
int32_t SD_Open(SD_BinaryReader &sdReader,
                string fileName, int32_t frameSize);

// ファイルの選択
void SelectFile(ButtonGroup &menu, FileSelector &selector,
                Label &msg, string &selectedName);

// フィルタの変更
void ModifyFilter(DesignerDrawer &drawerObj,
                  ButtonGroup &lpHp, ButtonGroup &onOff,
                  Biquad hn[], Biquad::Coefs ck[],
                  float &g0, bool &filterOn);

#endif  // F746_MY_FUNCTIONS_HPP
