//--------------------------------------------------------------
//  フィルタ処理付き SD オーディオプレーヤーで使う大域関数（ヘッダ）
//
//  2016/04/07, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------------

#include "MyFunctions.hpp"

// １フレーム分の信号処理 (IIR フィルタ) の実行
void ProcessSignal(SD_BinaryReader &sdReader, SaiIO_O &mySai,
                   int16_t sn[], float g0, Biquad hn[],
                   int order, bool filterOn)
{
    sdReader.Read(sn, mySai.GetLength());   // １フレーム分のデータを SD から読み込む

    while (!mySai.IsXferred()) {}  // データの転送が終わるまで待つ
    //--------------------------------------------------------------
    // １フレーム分の信号処理を行い，その結果を出力する
    for (int n=0; n<mySai.GetLength(); n++)
    {
        int16_t value;
        if (filterOn)       // フィルタ処理実行
        {
            // 縦続形の IIR フィルタ
            float yn = g0*sn[n];
            for (int k=0; k<order/2; k++) yn = hn[k].Execute(yn);
            value = (int16_t)yn;
        }
        else
            value = sn[n];  // フィルタ処理なし
        mySai.Output(value, value);    // 音響信号の出力
    }
    //--------------------------------------------------------------
    mySai.ResetXferred();   // 次のデータ転送に備える
}

// SD カードのファイルのオープン
int32_t SD_Open(SD_BinaryReader &sdReader,
                string fileName, int32_t frameSize)
{
    sdReader.Open(fileName);
    return sdReader.ReadSize()/frameSize;
}

// ファイルの選択
//      selectedName:   選択されたファイル名
void SelectFile(ButtonGroup &menu, FileSelector &selector,
                Label &msg, string &selectedName)
{
    msg.Draw("Select file");
    selector.DisplayFileList();   
    do
    {
        if (selector.Select(selectedName))
            menu.Activate(1);   // PLAY 有効
        wait_ms(200);
    } while (!menu.Touched(1)); // PLAY がタッチされるまで繰り返す
}

// フィルタの変更
void ModifyFilter(DesignerDrawer &drawerObj,
                   ButtonGroup &lpHp, ButtonGroup &onOff,
                   Biquad hn[], Biquad::Coefs ck[],
                   float &g0, bool &filterOn)
{
    // フィルタ処理の有効／無効切り替え
    int sw = 0;
    if (onOff.GetTouchedNumber(sw))
        filterOn = (sw == 0) ? true : false;

    // フィルタの周波数特性の変更
    static int num = 0;
    lpHp.GetTouchedNumber(num);
    BilinearDesign::Type typeLH = (BilinearDesign::Type)num;
    if (drawerObj.ReDesignAndDraw(ck, g0, typeLH))
        for (int k=0; k<drawerObj.GetOrder()/2; k++)
        {
            hn[k].SetCoefficients(ck[k]);
            hn[k].Clear();
        }
}
