//-----------------------------------------------------------
//  FrqRespDrawer class (Abstract base class)
//
//  2016/03/31, Copyright (c) 2016 MIKAMI, Naoki
//-----------------------------------------------------------

#include "FrquencyResponseDrawer.hpp"
#include "NumericLabel.hpp"

namespace Mikami
{
    // 目盛線の描画
    void FrqRespDrawer::DrawAxis()
    {
        uint16_t height = DB1_*(P_.MAX_DB - P_.MIN_DB);
        int logMin = (int)floorf(log10f(P_.MIN));
        int loop = (int)floorf(log10f(P_.MAX)) - logMin;

        lcd_->SetTextColor(P_.AXIS_COLOR);
        uint16_t y0 = P_.ORGY- height;
        lcd_->DrawVLine(X(P_.MIN), y0, height);      // 最小値に対応する線

        float du = powf(10.0, logMin);              // 座標値の増分
        float u1 = (floorf(P_.MIN/du) + 1.0f)*du;   // 最小値に対応する線の次の座標値

        for (int n=0; n<=loop; n++)
        {
            float uMax = (10.0f*du < P_.MAX) ? 10.0f*du : P_.MAX;
            for (float u=u1; u<uMax*0.99f; u+=du)
                lcd_->DrawVLine(X(u), y0, height);

            du = uMax;          // 値の増分を 10 倍する
            u1 = du;            // 次の for ループ の最初の値
        }

        lcd_->DrawVLine(X(P_.MAX), y0, height);      // 最大値に対応する線
        
        uint16_t width = X(P_.MAX) - X(P_.MIN);
        for (int n=0; n<= (P_.MAX_DB - P_.MIN_DB)/10; n++)
            lcd_->DrawHLine(X(P_.MIN), P_.ORGY-P_.DB10*n, width);
    }

    // 縦軸の数値の表示
    void FrqRespDrawer::DrawNumericY(int offsetX, int offsetY, int count,
                                     uint16_t d_dB, const char fmt[], sFONT &fonts,
                                     uint32_t textColor)
    {
        uint16_t x0 = P_.ORG + offsetX;
        uint16_t y0 = P_.ORGY + offsetY;
        for (int n=0; n<count; n++)
            new NumericLabel<int>(x0, y0-n*d_dB*DB1_,
                                  fmt, (int)(P_.MIN_DB+d_dB*n));
    }

    // 周波数特性のグラフの描画
    void FrqRespDrawer::DrawGraph()
    {
        lcd_->SetTextColor(P_.LINE_COLOR);
        uint16_t width = X(P_.MAX) - X(P_.MIN);   
        uint16_t x1 = 0;
        uint16_t y1 = 0;
        float pi2FsM = -6.283185f/P_.FS;    // -2*PI*Ts
        for (int n=0; n<=width; n++)
        {
            float frq = PosToFrq(n+P_.ORG);
            uint16_t x2 = X(frq);

            float absHz = AbsH_z(exp(Complex(0, pi2FsM*frq)));
            float dB = (absHz > 0.001f) ? 20.0f*log10f(absHz) : P_.MIN_DB;
            uint16_t y2 = P_.ORGY - Round((dB - P_.MIN_DB)*DB1_);
            if (y2 > P_.ORGY) y2 = P_.ORGY;

            if (n != 0) lcd_->DrawLine(x1, y1, x2, y2);

            x1 = x2;
            y1 = y2;
        }
        lcd_->SetTextColor(P_.AXIS_COLOR);
        lcd_->DrawHLine(X(P_.MIN), P_.ORGY, width);
    }

    // 消去
    void FrqRespDrawer::Erase()
    {
        lcd_->SetTextColor(P_.BACK_COLOR);
        uint16_t height = DB1_*(P_.MAX_DB - P_.MIN_DB);
        lcd_->FillRect(P_.ORG, P_.ORGY- height, X(P_.MAX)-X(P_.MIN)+1, height+1);
    }
}
