//--------------------------------------------------------------
//  BiquadFrqRespDrawer class (Derived class of FrqRespDrawer)
//  縦続形 IIR フィルタの周波数特性を描画するためのクラス
//  このクラスは，FrqRespDrawer の派生クラス
//
//  2016/03/31, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef F746_BILINEAR_FRQ_RESP_DRAWER_HPP
#define F746_BILINEAR_FRQ_RESP_DRAWER_HPP

#include "Biquad.hpp"
#include "FrquencyResponseDrawer.hpp"

namespace Mikami
{
    class BiquadFrqRespDrawer : public FrqRespDrawer
    {
    public:
        BiquadFrqRespDrawer(FrqRespDrawer::Params p)
            : FrqRespDrawer(p) {}

        // 次数とフィルタの係数設定
        void SetParams(int order, float g0, Biquad::Coefs ck[])
        {
            order_ = order;
            g0_ = g0;
            ck_ = ck;
        }
        
        // 周波数応答の絶対値を返す関数, 引数: z^(-1)
        virtual float AbsH_z(Complex u)
        {
            Complex h = g0_;
            for (int k=0; k<order_/2; k++)
            h = h*(1.0f + (ck_[k].b1 + ck_[k].b2*u)*u)
                /((1.0f - (ck_[k].a1 + ck_[k].a2*u)*u));
            return abs(h);
        }

    private:
        int order_;
        float g0_;
        Biquad::Coefs *ck_;
    };
}
#endif  // F746_BILINEAR_FRQ_RESP_DRAWER_HPP
