//------------------------------------------------------------------------------
//  Design of Butterworth LPF and HPF using bilinear transform -- Header
//
//   2016/03/31, Copyright (c) 2016 MIKAMI, Naoki
//------------------------------------------------------------------------------

#ifndef BILINEAR_BUTTERWORTH_HPP
#define BILINEAR_BUTTERWORTH_HPP

#include "mbed.h"
#include <complex>  // requisite

namespace Mikami
{
    typedef complex<float> Complex; // define "Complex"

    class BilinearDesign
    {
    public:
        struct Coefs { float a1, a2, b1, b2; };
        enum Type { LPF, HPF };

        // Constructor
        BilinearDesign(int order, float fs)
            : PI_FS_(PI_/fs), ORDER_(order)
        {
            sP_ = new Complex[order/2];
            zP_ = new Complex[order/2];
            ck_ = new Coefs[order/2];
        }

        // Destractor
        ~BilinearDesign()
        {
            delete[] sP_;
            delete[] zP_;
            delete[] ck_;
        }

        // Execution of design
        void Execute(float fc, Type pb, Coefs c[], float& g);

    private:
        static const float PI_ = 3.1415926536f;
        const float PI_FS_;
        const int ORDER_;

        Complex* sP_;   // Poles on s-plane
        Complex* zP_;   // Poles on z-plane
        Coefs* ck_;     // Coefficients of transfer function for cascade form
        float gain_;    // Gain factor for cascade form

        void Butterworth();
        void Bilinear(float fc);
        void ToCascade(Type pb);
        void GetGain(Type pb);
        void GetCoefs(Coefs c[], float& gain);
    };
}
#endif  // BILINEAR_BUTTERWORTH_HPP
