//------------------------------------------------------------------------------
//  IIR フィルタを双一次 z 変換で設計し，その周波数特性を描画するためのクラス -- Header
//  
//  2016/03/31, Copyright (c) 2016 MIKAMI, Naoki
//------------------------------------------------------------------------------

#ifndef F746_DISIGNER_AND_DRAWER_HPP
#define F746_DISIGNER_AND_DRAWER_HPP

#include "NumericLabel.hpp"
#include "TouchPanelDetectorX.hpp"
#include "BiquadFrqRespDrawer.hpp"
#include "BilinearDesignLH.hpp"

namespace Mikami
{
    class DesignerDrawer
    {
    public:
        // Constructor
        DesignerDrawer(uint16_t x0, uint16_t y0,
                       uint16_t db10, uint16_t fs, int order,
                       float fc, uint16_t fL, uint16_t fH,
                       BilinearDesign::Type lpHp);
               
        bool ReDesignAndDraw(Biquad::Coefs *ck, float &g0,
                             BilinearDesign::Type lpHp);
        
        void GetCoefficients(Biquad::Coefs *ck, float &g0);

    private:
        LCD_DISCO_F746NG *lcd_;
        TS_DISCO_F746NG *ts_;

        const uint16_t ORDER_;
        const uint16_t CURSOR_Y0_, CURSOR_LENGTH_;
        const uint16_t LOWER_F_, HIGHER_F_;
        const uint32_t CURSOR_COLOR_, CURSOR_TOUCHED_COLOR_;

        BilinearDesign::Coefs *coefs_;  // 設計された係数
        Biquad::Coefs *ck_;
        float g0_;                      // 設計された係数(利得定数)
        
        int fC_;    // 遮断周波数

        uint16_t cursorX_, oldCursorX_;
        bool cursorRedraw_;
        BilinearDesign::Type lp_;
        
        BiquadFrqRespDrawer *drawerObj_;
        BilinearDesign *designObj_;
        TouchPanelDetectorX *tp_;
        NumericLabel<int> *lblFrq_;
        
        // 周波数を 10, 20, 50, 100 Hz の倍数にする
        int Frq10(float f);
    };
}
#endif  // F746_DISIGNER_AND_DRAWER_HPP
