//---------------------------------------------------
//  CODEC を使い，MEMS マイクから入力した信号をそのまま
//  リアルタイムでヘッドフォン出力 (CN10) へ出力する
//
//  ライブラリのリビジョン：
//      F746_GUI     33
//      F746_SAI_IO  12
//      mbed        161
//
//  2018/03/12, Copyright (c) 2018 MIKAMI, Naoki
//---------------------------------------------------

#include "F746_GUI.hpp"
#include "WaveformDisplay.hpp"

#include "SAI_InOut.hpp"
using namespace Mikami;

int main()
{
    const uint32_t BACK_COLOR = GuiBase::ENUM_BACK;
    const uint32_t AXIS_COLOR = 0xFFCCFFFF;
    const uint32_t LINE_COLOR = LCD_COLOR_CYAN;

    const uint32_t N_DATA = 400;
    SaiIO mySai(SaiIO::BOTH, N_DATA, I2S_AUDIOFREQ_16K,
                INPUT_DEVICE_DIGITAL_MICROPHONE_2);

    LCD_DISCO_F746NG &lcd = GuiBase::GetLcd();
    lcd.Clear(BACK_COLOR);

    Label labelTitle(240, 10, "Demo of Audio I/O", Label::CENTER, Font16);

    const uint16_t BG_LEFT = 370;
    const uint16_t BG_WIDTH = 110;
    const uint16_t BG_HEIGHT = 40;

    ButtonGroup runStop(BG_LEFT, 230, BG_WIDTH/2, BG_HEIGHT,
                        2, (string[]){"RUN", "STOP"}, 0, 0, 2, 0);

    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetFont(&Font16);

    const int X_WAV = 30;   // x軸の原点
    const int Y_WAV = 80;   // y軸の原点 (Lチャンネル)
    WaveformDisplay waveDispL(lcd, X_WAV, Y_WAV, N_DATA, 7,
                              AXIS_COLOR, LINE_COLOR, BACK_COLOR);
    WaveformDisplay waveDispR(lcd, X_WAV, Y_WAV+80, N_DATA, 7,
                              AXIS_COLOR, LINE_COLOR, BACK_COLOR);
    Label labelL(445, Y_WAV- 8, "L", Label::LEFT, Font16);
    Label labelR(445, Y_WAV+72, "R", Label::LEFT, Font16);

    int16_t snL[N_DATA];
    int16_t snR[N_DATA];
    bool on = true;

    mySai.RecordIn();
    mySai.PlayOut();
    bool run = true;    // run

    while (true)
    {
        int sw = 0;
        if (runStop.GetTouchedNumber(sw))
        {
            on = (sw == 0) ? true : false;
            if (on && !run) mySai.ResumeOut();
            if (!on && run) mySai.PauseOut();
            run = on;
        }

        if (mySai.IsCompleted())
        {
            for (int n=0; n<mySai.GetLength(); n++)
            {
                int16_t xL;
                int16_t xR;
                mySai.Input(xL, xR);
                snL[n] = xL;    // 入力波形のモニタのため
                snR[n] = xR;    // 入力波形のモニタのため

                //----------------------------------------
                // ここにディジタルフィルタなどの処理を書く
                int16_t yL = xL;    // through の場合
                int16_t yR = xR;    // through の場合
                //----------------------------------------

                mySai.Output(yL, yR);
            }
            if (on)
            {
                waveDispL.Execute(snL);
                waveDispR.Execute(snR);
            }
        }    
    }
}
