//----------------------------------------------------------------------
//  残響発生器
//      残響発生処理の有効/無効の切り替え：PC の "F446_AD_DA_OnOff.exe"
//
//  2019/01/20, Copyright (c) 2019 MIKAMI, Naoki
//----------------------------------------------------------------------

#include "F446_Multirate.hpp"
#include "reverb_unit.hpp"      // 残響生成ユニット
#include "SerialRxTxIntr.hpp"
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため

using namespace Mikami;

int main()
{
    SerialRxTxIntr rxTx;    // Serial クラスの受送信割込み用オブジェクト
    F446_Multirate myAdDa;  // 出力標本化周波数を４倍にするオブジェクト
    const int FS = 10000;   // 入力の標本化周波数： 10 kHz

    const float G_C = 0.8f;
    const float G_A = 0.6f;
    const float G0 = 1.0f - G_C;
    CombFilter<887>    cm1(G_C);    // 櫛形フィルタによる残響生成ユニット
    CombFilter<1153>   cm2(G_C);    // 櫛形フィルタによる残響生成ユニット
    CombFilter<1499>   cm3(G_C);    // 櫛形フィルタによる残響生成ユニット
    AllpassFilter<97>  ap1(G_A);    // 全域通過フィルタによる残響生成ユニット
    AllpassFilter<131> ap2(G_A);    // 全域通過フィルタによる残響生成ユニット

    bool sw = true;     // 残響生成有効/無効のスイッチ

    // F446_Multirate::Start() と F446_Multirate::Input() の間に
    // printf() のように重い処理は実行しないこと．
    myAdDa.Start(FS);   // 標本化を開始する

    while (true)
    {
        //------------------------------------------------------------
        // ここにディジタルフィルタ等の処理を記述する
        float xn = myAdDa.Input();      // 入力
        float xn2 = G0*xn;

        // 櫛形フィルタの並列接続部
        float yn = cm1.Execute(xn2) + cm2.Execute(xn2)
                 + cm3.Execute(xn2);

        // 全域通過フィルタの縦続接続部
        yn = ap2.Execute(ap1.Execute(yn));

        // 入力信号（遅延なし）を加算
        yn = yn + xn2;

        if (sw) myAdDa.Output(yn);      // 出力：残響付き
        else    myAdDa.Output(xn);      // 出力：入力そのまま
        //------------------------------------------------------------

        //------------------------------------------------------------
        // PC からの指令に対応する処理
        if (rxTx.IsEol())           // 受信バッファのデータが有効になった場合の処理
        {
            string str = rxTx.GetBuffer();
            if (str == "ENQ")
                rxTx.Tx("ACK\n");   // PC からの "ENQ" に対して "ACK" を送信する
            else    // "ENQ" 以外の処理
            {
                if (str == "ST")    // PC から sw の状態の問い合わせ
                {
                    if (sw) rxTx.Tx("EN");     // 残響発生器が有効であることを返信
                    else    rxTx.Tx("DS");     // 残響発生器が無効であることを返信
                }
                if (str == "ON")  sw = true;
                if (str == "OFF") sw = false;  
            }
        }
        // PC からの指令に対応する処理はここまで
        //------------------------------------------------------------
    }
}

