//------------------------------------------------------------------------
//  双一次ｚ変換によるバタワースフィルタの設計（ヘッダ）
//      LPF, HPF のみ
//
//   2018/05/14, Copyright (c) 2018 MIKAMI, Naoki
//------------------------------------------------------------------------

#ifndef BILINEAR_BUTTERWORTH_HPP
#define BILINEAR_BUTTERWORTH_HPP

#include "mbed.h"
#include <complex>  // requisite
#include "Array.hpp"
#include "Biquad.hpp"

namespace Mikami
{
    typedef complex<float> Complex; // "Complex" を定義する

    class BilinearDesign
    {
    public:
        enum Type { LPF, HPF };

        // コンストラクタ
        BilinearDesign(int order, float fs)
            : PI_FS_(PI_/fs), ORDER_(order),
              sP_(order/2), zP_(order/2), ck_(order/2) {}

        // デストラクタ
        virtual ~BilinearDesign() {}

        // 設計の実行
        void Execute(float fc, Type pb, Biquad::Coefs c[], float& g);

    private:
        static const float PI_ = 3.1415926536f;
        const float PI_FS_;
        const int ORDER_;

        Array<Complex> sP_;         // s 平面上の極
        Array<Complex> zP_;         // z 平面上の極
        Array<Biquad::Coefs> ck_;   // Biquad構造の部分の係数
        float gain_;                // 利得定数

        void Butterworth();
        void Bilinear(float fc);
        void ToCascade(Type pb);
        void GetGain(Type pb);
        void GetCoefs(Biquad::Coefs c[], float& gain);
    };
}
#endif  // BILINEAR_BUTTERWORTH_HPP
