//----------------------------------------------------------------------
// マルチレート処理で使う補間用フィルタとしてデフォルトのフィルタ以外のものを
// 使いたい場合，ここでフィルタの係数を定義し，それを F446_Multirate のオブ
// ジェクトを実体化する際に，引数として渡す．
//
//  2019/01/31, Copyright (c) 2019 MIKAMI, Naoki
//----------------------------------------------------------------------

#include "F446_MultirateSWI.hpp"
#include "SerialRxTxIntr.hpp"
#include "BilinearDesignLH.hpp"
using namespace Mikami;

// マルチレート処理用の補間フィルタの係数
// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　： 8 次
// 標本化周波数：176.40 kHz
// 遮断周波数　： 20.00 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：40.00 dB
const Biquad HK_SM_[] = {
    Biquad(1.460326E+00f, -5.827534E-01f,  2.285060E-01f, 1.0f),  // 1段目
    Biquad(1.483366E+00f, -8.175905E-01f, -1.243800E+00f, 1.0f),  // 2段目
    Biquad(1.496830E+00f, -9.474507E-01f, -1.445014E+00f, 1.0f),  // 3段目
    Biquad(1.504313E+00f, -9.896493E-01f, -1.484535E+00f, 1.0f)}; // 4段目
const float G0_SM_ = 4*1.752428E-02f;   // 利得定数
const int ORDER_SM_ = 8;    // 次数
const int FS_ = 44100;      // 入力の標本化周波数： 44.1 kHz

