//------------------------------------------------------------------------------
//  Parameters calculator class of buquad unit for graphic equalizer (Header)
//  グラフィックイコライザで使う biquad フィルタの係数を計算するクラス（ヘッダ）
//
//   2018/06/04, Copyright (c) 2017 MIKAMI, Naoki
//------------------------------------------------------------------------------

#ifndef GRAPHIC_EQALIZER_PARAMETER_CALCULATOR_HPP
#define GRAPHIC_EQALIZER_PARAMETER_CALCULATOR_HPP

#include "mbed.h"
#include "BiquadGrEq.hpp"

namespace Mikami
{
    class GrEqParams
    {
    public:
        // Constructor
        GrEqParams(int bands, float fs) : BANDS_(bands), FS_(fs) {}

        // 計算した係数を取得する
        //      gDb : 利得（dB単位）
        BiquadGrEq::Coefs Get(int band, float f0, float gDb, float qVal);

    private:
        const int BANDS_;
        const float FS_;
    };
}
#endif  // GRAPHIC_EQALIZER_PARAMETER_CALCULATOR_HPP
