//--------------------------------------------------------------
//  グラフィックイコライザで使う 1D タイプの 2 次のフィルタ
//  Biquad filter of 1D type for graphic equalizer
//      このクラスでは，係数は実行中に書き換えられることを想定している
//
//      u[n] = x[n] + a1*u[n-1] + a2*u[n-2]
//      y[n] = b0*u[n] + b1*u[n-1] + b2*u[n-2]
//          x[n] :  input signal
//          y[n] :  output signal
//
// 2017/03/28, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef IIR_BIQUAD_GREQ_HPP
#define IIR_BIQUAD_GREQ_HPP

#include "mbed.h"

// 2nd order IIR filter
namespace Mikami
{
    class BiquadGrEq
    {
    public:
        struct Coefs { float a1, a2, b0, b1, b2; };

        BiquadGrEq(const Coefs ck = (Coefs){0, 0, 0, 0, 0})
        {
            SetCoefficients(ck);
            Clear();
        }
        
        void SetCoefficients(const Coefs cf) { cf_ = cf; }

        float Execute(float xn)
        {
            float un = xn + cf_.a1*un1_ + cf_.a2*un2_;
            float yn = cf_.b0*un + cf_.b1*un1_ + cf_.b2*un2_;
        
            un2_ = un1_;
            un1_ = un;

            return yn;
        }

        void Clear() { un1_ = un2_ = 0; }

    private:
        Coefs cf_;
        float un1_, un2_;

        // disallow copy constructor
        BiquadGrEq(const BiquadGrEq&);
    };
}
#endif  // IIR_BIQUAD_GREQ_HPP
