//--------------------------------------------------------------
//  Weaver 変調器を使う周波数シフタで使っているフィルタの係数
//--------------------------------------------------------------
#include "Biquad.hpp"

using namespace Mikami;

//--------------------------------------------------------------
// 入力帯域制限のための帯域通過フィルタの係数
//--------------------------------------------------------------
// 帯域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　： 8 次
// 標本化周波数： 10.00 kHz
// 遮断周波数１：  0.10 kHz
// 遮断周波数２：  4.50 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：40.00 dB
const int ORDER_BP_ = 8;    // 次数
const Biquad cBp_[ORDER_BP_/2] = {
    Biquad(-1.372774E+00f, -5.370704E-01f,  1.993219E+00f,  1.0f),  // 1段目
    Biquad( 1.873134E+00f, -8.814802E-01f, -1.999733E+00f,  1.0f),  // 2段目
    Biquad(-1.835442E+00f, -9.243853E-01f,  1.966710E+00f,  1.0f),  // 3段目
    Biquad( 1.980487E+00f, -9.841793E-01f, -1.998679E+00f,  1.0f)}; // 4段目
const float g0Bpf_ = 6.024895E-01f;     // 利得定数

//--------------------------------------------------------------
// Weaver 変調器で使う低域通過フィルタの係数
//--------------------------------------------------------------
// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　： 8 次
// 標本化周波数： 10.00 kHz
// 遮断周波数　：  2.20 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：40.00 dB
const int ORDER_LP_ = 8;    // 次数
const Biquad cLp_[ORDER_LP_/2] = {
    Biquad( 8.858544E-01f, -3.257468E-01f,  1.445936E+00f,  1.0f),  // 1段目
    Biquad( 5.719715E-01f, -7.185630E-01f,  1.417300E-01f,  1.0f),  // 2段目
    Biquad( 4.119452E-01f, -9.208622E-01f, -2.266002E-01f,  1.0f),  // 3段目
    Biquad( 3.685487E-01f, -9.845005E-01f, -3.103306E-01f,  1.0f)}; // 4段目
const float g0Lpf_ = 5.250112E-02f;     // 利得定数
