//-------------------------------------------------------
//  Class for spectrum analysis using linear prediction
//
//  2017/02/11, Copyright (c) 2017 MIKAMI, Naoki
//-------------------------------------------------------

#include "LPC_Analyzer.hpp"

namespace Mikami
{
    LpcAnalyzer::LpcAnalyzer(int nData, int nFft, int order)
        : AnalyzerBase(nData, nFft, nData-1), order_(order),
          lp_(nData-1, order),
          an_(order), xFft_(nFft), yFft_(nFft/2+1) {}

    void LpcAnalyzer::Analyze(const float xn[], float yn[])
    {
        float em;
        lp_.Execute(xn, an_, em);

        // To spectrum
        xFft_[0] = 1.0f;
        for (int n=0; n<order_; n++) xFft_[n+1] = -an_[n];
        for (int n=order_+1; n<N_FFT_; n++) xFft_[n] = 0.0f;
        fft_.Execute(xFft_, yFft_); // execute FFT

        // Translate to dB
        for (int n=0; n<=N_FFT_/2; n++)
            yn[n] = 10.0f*log10f(em/Norm(yFft_[n]));
    }
}
