//---------------------------------------------------------------
//  Class for spectrum analysis using linear prediction (Header)
//
//  2017/02/11, Copyright (c) 2017 MIKAMI, Naoki
//---------------------------------------------------------------

#ifndef LPC_ANALYZER_HPP
#define LPC_ANALYZER_HPP

#include "AnalyzerBase.hpp"
#include "LinearPrediction.hpp"

namespace Mikami
{
    class LpcAnalyzer : public AnalyzerBase
    {
    public:
        LpcAnalyzer(int nData, int nFft, int order);
        virtual ~LpcAnalyzer() {}
        
    private:
        int order_;
        LinearPred lp_;

        Array<float> an_;       // predictor coefficient 
        Array<float> xFft_;     // input for FFT
        Array<Complex> yFft_;   // output of FFT

        virtual void Analyze(const float xn[], float yn[]);

        // disallow copy constructor and assignment operator
        LpcAnalyzer(const LpcAnalyzer& );
        LpcAnalyzer& operator=(const LpcAnalyzer& );
    };
}
#endif  // LPC_ANALYZER_HPP
