//---------------------------------------------------------------------
//  データを PC へ転送
//
//  2018/10/07, Copyright (c) 2018 MIKAMI, Naoki
//---------------------------------------------------------------------

#include <string>
#include "Array.hpp"
#include "SerialRxTxIntr.hpp"
using namespace Mikami;

#ifndef MY_FUNCTION_XFER_HPP
#define MY_FUNCTION_XFER_HPP

extern SerialRxTxIntr rxTx_;

// データを PC へ転送（0 ～ 10,000 の範囲の値を 2 文字で表すコード化を利用）
void Xfer(Array<uint16_t> &xn)
{
    string str = "";
    for (int n=0; n<xn.Length(); n++)
    {
        div_t a = div(xn[n], 100);
        str += a.quot + 0x10;
        str += a.rem + 0x10;
    }
    rxTx_.Tx(str+"\n");
    rxTx_.Tx("EOT\n");
}

#endif  // MY_FUNCTION_XFER_HPP
