//-----------------------------------------------------
//  Class for linear prediction (Header)
//
//  2017/02/11, Copyright (c) 2017 MIKAMI, Naoki
//-----------------------------------------------------

#ifndef LINEAR_PREDICTION_HPP
#define LINEAR_PREDICTION_HPP

#include "Array.hpp"

namespace Mikami
{
    class LinearPred
    {
    public:
        LinearPred(int nData, int order);
        ~LinearPred() {}
        bool Execute(const float x[], float a[], float &em);
    private:
        const uint16_t N_DATA_;

        uint16_t order_;

        Array<float> r_;    // for auto-correlation
        Array<float> k_;    // for PARCOR coefficients
        Array<float> am_;   // working area

        void AutoCorr(const float x[]);
        bool Durbin(float a[], float &em);

        // disallow copy constructor and assignment operator
        LinearPred(const LinearPred& );
        LinearPred& operator=(const LinearPred& );
    };
}
#endif  // LINEAR_PREDICTION_HPP
