//-------------------------------------------------------
//  Base abstract class for spectrum analysis
//
//  2017/02/09, Copyright (c) 2017 MIKAMI, Naoki
//-------------------------------------------------------

#include "AnalyzerBase.hpp"

namespace Mikami
{
    AnalyzerBase::AnalyzerBase(int nData, int nFft, int nUse)
        : N_DATA_(nData), N_FFT_(nFft),
          fft_(nFft), wHm_(nData-1, nUse), b1_(1.0f),
          xData_(nUse), wData_(nUse) {}

    void AnalyzerBase::Execute(const float xn[], float db[])
    {
        // 高域強調
        for (int n=0; n<N_DATA_-1; n++)
            xData_[n] = xn[n+1] - b1_*xn[n];
            
        // 窓掛け
        wHm_.Execute(xData_, wData_);
            
        Analyze(wData_, db);
    }
}
