//--------------------------------------------------------------------
//  STM32F446 と信号処理用ボードによるデモプログラムで使うグローバル関数
//
//  2017/01/30, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------------

#include "SignalProcessing.hpp"     // 信号処理の抽象基底クラスなど
#include "AQM1602.hpp"
using namespace Mikami;

extern SignalProcessing *spPtr_;    // 処理に対応するポインタ

// 機能の割り当てと表示
void AssignDisplay(SignalProcessing &func, Aqm1602 &lcd,
                   char str[], float val = -1)
{
    spPtr_ = &func;     // 機能の割り当て

    // 表示
    lcd.ClearLine(0);
    lcd.ClearLine(1);
    printf("%s", str);
    lcd.WriteStringXY(str, 0, 0);

    if (val != -1)
    {
        printf(", %4.0f Hz", val);
        lcd.WriteValueXY("%4.0f Hz", val, 0, 1);
    }
    printf("\r\n");
}

// 周波数変化が基準値より大きい場合に true を返す
//      min <= frq <= max
//      th : 基準値
bool FrChange(AnalogIn &aIn, float min, float max, float th, float &frq)
{
    static float frqCurrent = 0;
    frq = (max - min)*aIn.read() + min;
    if (fabs(frq - frqCurrent) > th)
    {
        frqCurrent = frq;
        return true;
    }
    else
        return false;
}
