//--------------------------------------------------------------
//  Weaver 変調器を使う周波数シフタで使っているフィルタの係数
//--------------------------------------------------------------

#include "Biquad.hpp"

using namespace Mikami;

//--------------------------------------------------------------
// 直流分除去フィルタの係数
//--------------------------------------------------------------
// 高域通過フィルタ
// バタワース特性
// 次数　　　　：2 次
// 標本化周波数： 24.00 kHz
// 遮断周波数　：  0.05 kHz
const Mikami::Biquad::Coefs weaver_c1_ =
    { 1.981489E+00f, -9.816583E-01f, -2.0f, 1.0f};

const float weaver_g0_ = 9.907867E-01f;

//--------------------------------------------------------------
// Weaver 変調器で使う低域通過フィルタの係数
//--------------------------------------------------------------
// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　：8 次
// 標本化周波数： 24.00 kHz
// 遮断周波数　：  4.90 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：60.00 dB
const int WEAVER_ORDER_ = 8;   // 次数
const Biquad::Coefs weaver_ck_[WEAVER_ORDER_/2] = {
    { 1.160215E+00f, -4.185278E-01f,  1.616618E+00f,  1.0f},    // 1段目
    { 8.636285E-01f, -6.678471E-01f,  3.656119E-01f,  1.0f},    // 2段目
    { 6.381001E-01f, -8.651304E-01f, -1.685791E-01f,  1.0f},    // 3段目
    { 5.524897E-01f, -9.656778E-01f, -3.300526E-01f,  1.0f} };  // 4段目
const float weaver_g0Lpf_ = 1.299688E-02f;    // 利得定数
