//--------------------------------------------------------------
//  残響生成器
//
// 2017/01/31, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef ECHO_SYSTEM_HPP
#define ECHO_SYSTEM_HPP

#include "ReverbUnit.hpp"

class EchoSystem : public SignalProcessing
{
public:
    EchoSystem(float gC = 0.8f, float gA = 0.6f)
        : G0_(1.0f - gC),
          cmF1_(gC, 1759), cmF2_(gC, 1543),
          cmF3_(gC, 1319), cmF4_(gC, 1301),
          apF1_(gA, 241), apF2_(gA, 173) {}
    
    virtual float Execute(float xn1, float xn2)
    {
        float xn = G0_*(xn1 + xn2)*0.5f;
        float yn = cmF1_.Execute(xn) + cmF2_.Execute(xn)
                 + cmF3_.Execute(xn) + cmF4_.Execute(xn);
        yn = apF2_.Execute(apF1_.Execute(yn));
        yn = yn + xn;   // add direct input signal
        return yn;
    }

private:
    const float G0_;

    CombFilter cmF1_, cmF2_, cmF3_, cmF4_;
    AllPassFilter apF1_, apF2_;
};
#endif  // ECHO_SYSTEM_HPP
