//--------------------------------------------------------------
// IIR filter ---- Cascade structure

// 2017/01/26, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef IIR_CASCADE_HPP
#define IIR_CASCADE_HPP

#include "mbed.h"
#include "Biquad.hpp"
#include "Array.hpp"
using namespace Mikami;

namespace Mikami
{
    // IIR filter -- Cascade structure
    class IirCascade
    {
    public:
        IirCascade(int order, float g0 = 1,
                   const Biquad::Coefs ck[] = NULL)
            : ORDER2_(order/2), hk_(order/2)
        {
            if (ck != NULL) SetCoefs(g0, ck);
            else            g0_ = g0;
        }

        void SetCoefs(float g0, const Biquad::Coefs ck[])
        {
            g0_ = g0;
            for (int k=0; k<ORDER2_; k++) hk_[k].SetCoefs(ck[k]);
        }

        void GetCoefs(float &g0, Biquad::Coefs ck[])
        {
            g0 = g0_;
            for (int k=0; k<ORDER2_; k++) hk_[k].GetCoefs(ck[k]);
        }

        float Execute(float xn)
        {
            float yn = g0_*xn;
            for (int k=0; k<ORDER2_; k++)
                yn = hk_[k].Execute(yn);
                
            return yn;
        }
        
        void Clear()
        {
            for (int k=0; k<ORDER2_; k++)
                hk_[k].Clear();
        }

    private:
        const int ORDER2_;
        Array<Biquad> hk_;  // Elements of cascade structure
        float g0_;          // gain factor

        // disallow copy constructor and assignment operator
        IirCascade(const IirCascade&);
        IirCascade& operator=(const IirCascade&);
    };
}
#endif  // IIR_CASCADE_HPP
