//--------------------------------------------------------------
// 信号処理の抽象基底クラスおよびその派生クラスの中で簡単なクラス
//
// 2017/01/30, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef SIGNAL_PROSECCING_BASE_CLASS_HPP
#define SIGNAL_PROSECCING_BASE_CLASS_HPP

// 信号処理の抽象基底クラス
class SignalProcessing
{
public:
    virtual float Execute(float xn1, float xn2) = 0;
};

//---------------------------------------
//          以下は派生クラス
//---------------------------------------

// 入力をそのまま出力する
class Through : public SignalProcessing
{
public:
    virtual float Execute(float xn1, float xn2)
    { return (xn1 + xn2)*0.5f; }
};

// ボーカルキャンセラ
class VocalCanceller : public SignalProcessing
{
public:
    virtual float Execute(float xn1, float xn2)
    { return xn1 - xn2; }
};
#endif  // SIGNAL_PROSECCING_BASE_CLASS_HPP
