//--------------------------------------------------------------
// 遮断周波数可変フィルタ，LPF と HPF
//
// 2017/01/30, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef VARIABLE_LOWPASS_HIGHPASS_FILTER_HPP
#define VARIABLE_LOWPASS_HIGHPASS_FILTER_HPP

#include "IIR_Cascade.hpp"
#include "SignalProcessing.hpp"
#include "BilinearDesignLH.hpp"
#include "Array.hpp"
using namespace Mikami;

class VariableLpHp  : public SignalProcessing
{
public:
    VariableLpHp(int order, float fs)
        : ORDER2_(order/2), coefs_(order/2), coefsIir_(order/2),
          designer_(order, fs), filter_(order) {}

    virtual float Execute(float xn1, float xn2)
    { return filter_.Execute((xn1 + xn2)*0.5f); }

    void Design(float fc, BilinearDesign::Type passBand)
    {
        float g0;
        designer_.Execute(fc, passBand, coefs_, g0);
        for (int n=0; n<ORDER2_; n++)
            coefsIir_[n] = *(Biquad::Coefs *)&coefs_[n];

        filter_.SetCoefs(g0, coefsIir_);
        filter_.Clear();
    }

private:
    const int ORDER2_;

    Array<BilinearDesign::Coefs> coefs_;
    Array<Biquad::Coefs> coefsIir_;

    BilinearDesign designer_;
    IirCascade filter_;
};
#endif  // VARIABLE_LOWPASS_HIGHPASS_FILTER_HPP
