//--------------------------------------------------------
//  Class for buit-in single DAC on STM32F446 ---- Header
//
//  STM32F446 内蔵の DAC 用のクラス（ヘッダ）
//      選択可能な入力端子：
//          A2  (PA_4)： ---- デフォルト
//          D13 (PA_5)： このポートはマイコンボードの LED もドライブするので
//                       このポートは使わない方がよい
//
//  2018/11/28, Copyright (c) 2018 MIKAMI, Naoki
//--------------------------------------------------------

#include "mbed.h"

#ifndef STM32F446xx
#error Not NUCLEO-F446RE.
#endif

#ifndef F446_DAC_SINGLE_HPP
#define F446_DAC_SINGLE_HPP

namespace Mikami
{
    class DacF446
    {
    public:
        // Constructor
        explicit DacF446(PinName pin = A2);

        virtual ~DacF446() {}

        // -1.0f <= data <= 1.0f
        void Write(float data) { WriteDac(ToUint16(data)); }

        // 0 <= data <= 4095
        void Write(uint16_t data) { WriteDac(__USAT(data, BIT_WIDTH_)); }

    private:
        void (DacF446::*fpWriteDac)(uint16_t);

        static const int BIT_WIDTH_ = 12;
        AnalogOut da_;

        // DAC の片方のチェンネルへ出力する
        void WriteDac1(uint16_t val) { DAC->DHR12R1 = val; }    // CH1 へ
        void WriteDac2(uint16_t val) { DAC->DHR12R2 = val; }    // CH2 へ
        
        void WriteDac(uint16_t val) { (this->*fpWriteDac)(val); }

        // 飽和処理を行い uint16_t 型のデータを戻り値とする
        uint16_t ToUint16(float val)
        {   return __USAT((val + 1.0f)*2048.0f, BIT_WIDTH_); }

        // for inhibition of copy constructor
        DacF446(const DacF446&);
        // for inhibition of substitute operator
        DacF446& operator=(const DacF446&);     
    };
}
#endif  // F446_DAC_SINGLE_HPP

