//--------------------------------------------------------
//  バッファの template クラス
//      バッファに２次元配列（Matrix クラス）を使用
//
//  2020/10/17, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------

#ifndef INPUT_BUFFER_HPP
#define INPUT_BUFFER_HPP

#include "Matrix.hpp"
using namespace Mikami;

template<class T> class InputBuffer
{
public:
    // コンストラクタ
    explicit InputBuffer(int size, T initialValue = 0)
        : N_(size), buf_(2, size, initialValue), index_(0), full_(false) {}
    
    // データを格納
    void Store(T data1, T data2)
    {
        buf_[0][index_] = data1;
        buf_[1][index_++] = data2;
    }
    
    // 出力バッファからデータの取り出し
    T Get(int ch, int n) const { return buf_[ch][n]; }

    // バッファが満杯で次の準備を行う
    bool IsFullNext()
    {
        if (index_ < N_) return false;

        index_ = 0;
        full_ = true;
        return true;
    }

    // バッファが満杯で，true を返す
    bool IsFull()
    {
        bool temp = full_;
        if (full_) full_ = false;
        return temp;
    }

private:
    const int N_;       // バッファのサイズ
    Matrix<T> buf_;     // バッファ
    int index_;         // 入力データのカウンタ
    bool full_;         // 満杯の場合 true

    // コピー･コンストラクタおよび代入演算子の禁止のため
    InputBuffer(const InputBuffer&);
    InputBuffer& operator=(const InputBuffer&);
};
#endif  // INPUT_BUFFER_HPP