//---------------------------------------------------------
//  M 系列信号発生器（N = 16）
//
//  2020/10/17, Copyright (c) 2020 MIKAMI, Naoki
//---------------------------------------------------------

#include "mbed.h"

#ifndef MSEQ16_HPP
#define MSEQ16_HPP

namespace Mikami
{
    class MSeq16
    {
    public:
        MSeq16() : reg_(1) {}

        // 戻り値： 1 => 1, 0 => -1
        int Execute()
        {
            if ((reg_ & B_M_) == B_M_)
            {
                reg_ = ((reg_ ^ XOR_) << 1) | 1;    // 1 の場合の処理
                return 1;
            }
            else
            {
                reg_ = reg_ << 1;                   // 0 の場合の処理
                return -1;
            }
        }
    private:
        static const uint16_t XOR_ = (1 << (2-1))
                                   | (1 << (3-1))
                                   | (1 << (5-1));  // XOR の位置に対応する定数
        static const uint16_t B_M_ = 1 << (16-1);   // 16 段目に相当するビットを調べる
        
        uint16_t reg_;
    };
}
#endif  // MSEQ16_HPP