//---------------------------------------------------
//  縦続形 IIR フィルタ（ヘッダ）
//
// 2020/05/30, Copyright (c) 2020 MIKAMI, Naoki
//---------------------------------------------------

#ifndef IIR_CASCADE_HPP
#define IIR_CASCADE_HPP

#include "Biquad.hpp"
#include "Array.hpp"    // Array クラスが定義されている

namespace Mikami
{
    class IirCascade
    {
    public:
        // コンストラクタ
        IirCascade(int order = 0, const Biquad::Coefs ck[] = NULL,
                   float g0 = 1);

        // フィルタ処理を実行する
        float Execute(float xn);

        // 係数の設定
        void SetCoefs(int order, const Biquad::Coefs ck[], float g0);

        // 内部変数（遅延器）のクリア
        void Clear()
        {   for (int k=0; k<hOrder_; k++) bq_[k].Clear(); }

    private:
        int hOrder_;        // 次数/2
        Array<Biquad> bq_;  // Biquad クラスのオブジェクトの配列
        float g0_;          // 利得定数

        // コピー･コンストラクタ，代入演算子禁止禁止のため
        IirCascade(const IirCascade&);
        IirCascade& operator=(const IirCascade&);
    };
}
#endif  // IIR_CASCADE_HPP