//---------------------------------------------------
//  縦続形 IIR フィルタ
//
// 2020/05/30, Copyright (c) 2020 MIKAMI, Naoki
//---------------------------------------------------

#include "IIR_Cascade.hpp"

namespace Mikami
{
    // コンストラクタ
    IirCascade::IirCascade(int order, const Biquad::Coefs ck[], float g0)
    {   
        SetCoefs(order, ck, g0);
        Clear();
    }

    // フィルタ処理を実行する
    float IirCascade::Execute(float xn)
    {
        float yn = g0_*xn;
        for (int k=0; k<hOrder_; k++) yn = bq_[k].Execute(yn);
        return yn;
    }

    // 係数の設定
    void IirCascade::SetCoefs(int order, const Biquad::Coefs ck[], float g0)
    {
            printf("SetCoefs called!\r\n");
        if (hOrder_ != ((order+1)>>1))
        {
            hOrder_ = (order+1)>>1;
            bq_.SetSize(hOrder_);
            Clear();
                printf("Order changed!\r\n");
        }
        g0_ = g0;
        for (int k=0; k<hOrder_; k++) bq_[k].SetCoefs(ck[k]);
    }
}