//--------------------------------------------------------------
// 縦続形 IIR フィルタの構成要素として使う 2 次の IIR フィルタ（ヘッダ）
//      b0 は 1 と仮定している
//
// 2020/02/12, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef IIR_BIQUAD_HPP
#define IIR_BIQUAD_HPP

#include "mbed.h"

namespace Mikami
{
    class Biquad
    {
    public:
        // フィルタの係数をまとめて扱うための構造体
        struct Coefs { float a1, a2, b1, b2; };

        // デフォルト･コンストラクタ
        //      係数は構造体 Ceofs で与える
        Biquad(const Coefs ck = (Coefs){0, 0, 0, 0});

        // 係数を個別に与えるコンストラクタ
        Biquad(float a1, float a2, float b1, float b2);

        // 2 次のフィルタを実行する
        float Execute(float xn);

        // 係数を設定する
        void SetCoefs(const Coefs ck);

        // 内部変数（遅延器）のクリア
        void Clear() { un1_ = un2_ = 0; }

    private:
        float a1_, a2_, b1_, b2_;
        float un1_, un2_;

        // コピー･コンストラクタ禁止のため
        Biquad(const Biquad&);
    };
}
#endif  // IIR_BIQUAD_HPP