//--------------------------------------------------------------
// 縦続形 IIR フィルタの構成要素として使う 2 次の IIR フィルタ
//      b0 は 1 と仮定している
//
// 2020/02/12, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------------

#include "Biquad.hpp"

namespace Mikami
{
    // デフォルト･コンストラクタ
    //      係数は構造体 Ceofs で与える
    Biquad::Biquad(const Coefs ck)
        : a1_(ck.a1), a2_(ck.a2), b1_(ck.b1), b2_(ck.b2) { Clear(); }       

    // 係数を個別に与えるコンストラクタ
    Biquad::Biquad(float a1, float a2, float b1, float b2)
        : a1_(a1), a2_(a2), b1_(b1), b2_(b2) { Clear(); }

    // 2 次のフィルタを実行する
    float Biquad::Execute(float xn)
    {
        float un = xn + a1_*un1_ + a2_*un2_;
        float yn = un + b1_*un1_ + b2_*un2_;
    
        un2_ = un1_;
        un1_ = un;

        return yn;
    }

    // 係数を設定する
    void Biquad::SetCoefs(const Coefs ck)
    {
        a1_ = ck.a1;
        a2_ = ck.a2;
        b1_ = ck.b1;
        b2_ = ck.b2;
    }
}